@extends('layouts.app')

@section('title', 'Ban Details - ' . ($ban->player_name ?: 'Unknown Player'))

@section('content')
<div class="sam-bans-container">
    <!-- Header with Back Button -->
    <div class="sam-detail-header">
        <a href="{{ route('sambans.index') }}" class="sam-btn sam-btn-secondary">
            <i class="fas fa-arrow-left"></i>
            Back to Bans
        </a>
        
        <h1 class="sam-detail-title">
            <i class="fas fa-shield-alt"></i>
            Ban Details
        </h1>
    </div>

    <!-- Ban Information Card -->
    <div class="sam-detail-card">
        <div class="sam-card-header">
            <div class="sam-card-title">
                <i class="fas fa-user"></i>
                Player Information
            </div>
            <div class="sam-card-status">
                <span class="sam-status-badge sam-status-{{ $ban->status }}">
                    @switch($ban->status)
                        @case('permanent')
                            <i class="fas fa-infinity"></i> Permanent Ban
                            @break
                        @case('active')
                            <i class="fas fa-exclamation-triangle"></i> Active Ban
                            @break
                        @case('expired')
                            <i class="fas fa-clock"></i> Expired Ban
                            @break
                    @endswitch
                </span>
            </div>
        </div>

        <div class="sam-card-content">
            <div class="sam-detail-grid">
                <!-- Player Info Section -->
                <div class="sam-detail-section">
                    <h3 class="sam-section-title">Player Details</h3>
                    <div class="sam-detail-rows">
                        <div class="sam-detail-row">
                            <span class="sam-detail-label">Player Name:</span>
                            <span class="sam-detail-value sam-player-name">
                                {{ $ban->player_name ?: 'Unknown Player' }}
                            </span>
                        </div>
                        
                        <div class="sam-detail-row">
                            <span class="sam-detail-label">SteamID (32):</span>
                            <span class="sam-detail-value">
                                <code class="sam-steamid">{{ $ban->steamid }}</code>
                            </span>
                        </div>

                        @if($ban->steamid64)
                            <div class="sam-detail-row">
                                <span class="sam-detail-label">SteamID (64):</span>
                                <span class="sam-detail-value">
                                    <code class="sam-steamid">{{ $ban->steamid64 }}</code>
                                </span>
                            </div>

                            <div class="sam-detail-row">
                                <span class="sam-detail-label">Steam Profile:</span>
                                <span class="sam-detail-value">
                                    <a href="{{ $ban->steam_profile_url }}" target="_blank" class="sam-steam-profile-link">
                                        <i class="fab fa-steam"></i>
                                        View Profile
                                    </a>
                                </span>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Ban Info Section -->
                <div class="sam-detail-section">
                    <h3 class="sam-section-title">Ban Information</h3>
                    <div class="sam-detail-rows">
                        <div class="sam-detail-row">
                            <span class="sam-detail-label">Reason:</span>
                            <span class="sam-detail-value sam-ban-reason">
                                {{ $ban->formatted_reason }}
                            </span>
                        </div>

                        <div class="sam-detail-row">
                            <span class="sam-detail-label">Duration:</span>
                            <span class="sam-detail-value">
                                @if($ban->is_permanent)
                                    <span class="sam-permanent">Permanent</span>
                                @elseif($ban->is_active)
                                    <span class="sam-active">{{ $ban->time_remaining }}</span>
                                @else
                                    <span class="sam-expired">Expired</span>
                                @endif
                            </span>
                        </div>

                        @if($ban->unban_date_human)
                            <div class="sam-detail-row">
                                <span class="sam-detail-label">Expires:</span>
                                <span class="sam-detail-value">
                                    {{ $ban->unban_date_human->format('M j, Y \a\t g:i A') }}
                                    <span class="sam-detail-subtext">({{ $ban->unban_date_human->diffForHumans() }})</span>
                                </span>
                            </div>
                        @endif

                        <div class="sam-detail-row">
                            <span class="sam-detail-label">Admin:</span>
                            <span class="sam-detail-value sam-admin-name">
                                {{ $ban->admin_name ?: $ban->admin }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Player History -->
    @if($playerHistory && $playerHistory->count() > 1)
        <div class="sam-detail-card">
            <div class="sam-card-header">
                <div class="sam-card-title">
                    <i class="fas fa-history"></i>
                    Ban History for {{ $ban->player_name ?: 'this Player' }}
                </div>
                <div class="sam-card-subtitle">
                    {{ $playerHistory->count() }} total ban(s)
                </div>
            </div>

            <div class="sam-card-content">
                <div class="sam-history-list">
                    @foreach($playerHistory as $index => $historyBan)
                        <div class="sam-history-item {{ $historyBan->steamid === $ban->steamid ? 'sam-current-ban' : '' }}">
                            <div class="sam-history-header">
                                <span class="sam-history-number">#{{ $playerHistory->count() - $index }}</span>
                                <span class="sam-status-badge sam-status-{{ $historyBan->status }}">
                                    @switch($historyBan->status)
                                        @case('permanent')
                                            <i class="fas fa-infinity"></i> Permanent
                                            @break
                                        @case('active')
                                            <i class="fas fa-exclamation-triangle"></i> Active
                                            @break
                                        @case('expired')
                                            <i class="fas fa-clock"></i> Expired
                                            @break
                                    @endswitch
                                </span>
                                @if($historyBan->steamid === $ban->steamid)
                                    <span class="sam-current-indicator">Current Ban</span>
                                @endif
                            </div>

                            <div class="sam-history-content">
                                <div class="sam-history-reason">
                                    <strong>Reason:</strong> {{ $historyBan->formatted_reason }}
                                </div>
                                <div class="sam-history-details">
                                    <span class="sam-history-admin">
                                        <i class="fas fa-user-shield"></i>
                                        {{ $historyBan->admin_name ?: $historyBan->admin }}
                                    </span>
                                    <span class="sam-history-duration">
                                        <i class="fas fa-clock"></i>
                                        @if($historyBan->is_permanent)
                                            Permanent
                                        @elseif($historyBan->unban_date_human)
                                            {{ $historyBan->unban_date_human->diffForHumans() }}
                                        @else
                                            Unknown duration
                                        @endif
                                    </span>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif

    <!-- Action Buttons -->
    <div class="sam-detail-actions">
        <a href="{{ route('sambans.index') }}" class="sam-btn sam-btn-primary">
            <i class="fas fa-list"></i>
            View All Bans
        </a>
        
        @if($ban->steamid64)
            <a href="{{ $ban->steam_profile_url }}" target="_blank" class="sam-btn sam-btn-info">
                <i class="fab fa-steam"></i>
                Steam Profile
            </a>
        @endif

        <a href="{{ route('sambans.players') }}" class="sam-btn sam-btn-secondary">
            <i class="fas fa-users"></i>
            View Players
        </a>
    </div>
</div>

<style>
.sam-detail-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: var(--spacing-xl);
    flex-wrap: wrap;
    gap: var(--spacing-md);
}

.sam-detail-title {
    font-size: 2rem;
    font-weight: 700;
    color: var(--white);
    margin: 0;
    display: flex;
    align-items: center;
    gap: var(--spacing-md);

    i {
        color: var(--primary-color);
    }
}

.sam-detail-card {
    background: var(--dark-gray-lighter);
    border-radius: var(--border-radius-lg);
    border: 1px solid var(--dark-gray-lightest);
    box-shadow: var(--box-shadow-md);
    margin-bottom: var(--spacing-xl);
    overflow: hidden;
}

.sam-card-header {
    background: var(--dark-gray-lightest);
    padding: var(--spacing-lg);
    border-bottom: 1px solid var(--dark-gray-lightest);
    display: flex;
    align-items: center;
    justify-content: space-between;
    flex-wrap: wrap;
    gap: var(--spacing-md);
}

.sam-card-title {
    font-size: 1.3rem;
    font-weight: 600;
    color: var(--white);
    display: flex;
    align-items: center;
    gap: var(--spacing-sm);

    i {
        color: var(--primary-color);
    }
}

.sam-card-subtitle {
    color: var(--light-gray);
    font-size: 0.9rem;
}

.sam-card-content {
    padding: var(--spacing-lg);
}

.sam-detail-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: var(--spacing-xl);
}

.sam-detail-section {
    .sam-section-title {
        font-size: 1.1rem;
        font-weight: 600;
        color: var(--primary-light);
        margin-bottom: var(--spacing-md);
        padding-bottom: var(--spacing-sm);
        border-bottom: 1px solid var(--dark-gray-lightest);
    }

    .sam-detail-rows {
        display: flex;
        flex-direction: column;
        gap: var(--spacing-md);
    }

    .sam-detail-row {
        display: flex;
        flex-direction: column;
        gap: var(--spacing-xs);

        .sam-detail-label {
            font-size: 0.9rem;
            color: var(--light-gray);
            font-weight: 500;
        }

        .sam-detail-value {
            color: var(--white);
            font-weight: 500;

            &.sam-player-name {
                font-size: 1.1rem;
                color: var(--primary-light);
            }

            &.sam-ban-reason {
                color: var(--lighter-gray);
                background: var(--dark-gray-lightest);
                padding: var(--spacing-sm);
                border-radius: var(--border-radius-sm);
                line-height: 1.4;
            }

            &.sam-admin-name {
                color: var(--info);
            }

            .sam-detail-subtext {
                font-size: 0.8rem;
                color: var(--mid-gray);
                font-weight: normal;
            }
        }
    }
}

.sam-steam-profile-link {
    color: var(--info);
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: var(--spacing-xs);
    transition: var(--transition-fast);

    &:hover {
        color: var(--primary-color);
    }
}

.sam-permanent {
    color: var(--danger);
    font-weight: 600;
}

.sam-active {
    color: var(--warning);
    font-weight: 600;
}

.sam-expired {
    color: var(--mid-gray);
    font-style: italic;
}

.sam-history-list {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-md);
}

.sam-history-item {
    background: var(--dark-gray-lightest);
    border-radius: var(--border-radius-md);
    padding: var(--spacing-md);
    border: 1px solid transparent;
    transition: var(--transition-fast);

    &.sam-current-ban {
        border-color: var(--primary-color);
        background: rgba(75, 139, 255, 0.1);
    }

    .sam-history-header {
        display: flex;
        align-items: center;
        gap: var(--spacing-md);
        margin-bottom: var(--spacing-sm);
        flex-wrap: wrap;

        .sam-history-number {
            background: var(--mid-gray);
            color: var(--white);
            padding: var(--spacing-xs) var(--spacing-sm);
            border-radius: var(--border-radius-sm);
            font-size: 0.8rem;
            font-weight: 600;
        }

        .sam-current-indicator {
            background: var(--primary-color);
            color: var(--white);
            padding: var(--spacing-xs) var(--spacing-sm);
            border-radius: var(--border-radius-sm);
            font-size: 0.8rem;
            font-weight: 600;
        }
    }

    .sam-history-content {
        .sam-history-reason {
            color: var(--lighter-gray);
            margin-bottom: var(--spacing-sm);
            line-height: 1.4;
        }

        .sam-history-details {
            display: flex;
            gap: var(--spacing-lg);
            font-size: 0.9rem;
            color: var(--light-gray);
            flex-wrap: wrap;

            span {
                display: flex;
                align-items: center;
                gap: var(--spacing-xs);
            }
        }
    }
}

.sam-detail-actions {
    display: flex;
    gap: var(--spacing-md);
    justify-content: center;
    flex-wrap: wrap;
    margin-top: var(--spacing-xl);
    padding: var(--spacing-lg);
    background: var(--dark-gray-lighter);
    border-radius: var(--border-radius-lg);
    border: 1px solid var(--dark-gray-lightest);
}

@media (max-width: var(--breakpoint-md)) {
    .sam-detail-header {
        flex-direction: column;
        align-items: stretch;
        text-align: center;
    }

    .sam-detail-grid {
        grid-template-columns: 1fr;
    }

    .sam-card-header {
        flex-direction: column;
        align-items: stretch;
        text-align: center;
    }

    .sam-detail-actions {
        flex-direction: column;
    }
}
</style>
@endsection